/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.service.serviceaction;

import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.service.managedsystem.fru.Fru;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.service.cec.sf2.fru.SF2PowerSupply;
import com.ibm.hwmca.xfw.pa.fru.CommonFruList;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.service.serviceaction.DefaultProblemVerificationFilter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PIProblemVerificationFilter
extends DefaultProblemVerificationFilter {
    private static final String TRACE_MASKT = "XRVPIVFT";
    private static final String TRACE_MASKF = "XRVPIVFF";
    private static final String TRACE_MASKD = "XRVPIVFD";

    protected boolean isRelatedProblem(CommonProblem sourceProblem, CommonProblem verifyProblem) {
        Trace.trace(TRACE_MASKT, "-> PIProblemVerificationFilter.isRelatedProblem, sourceProblem key(" + sourceProblem.getUniqueKey() + "), verifyProblem key(" + verifyProblem.getUniqueKey() + ")");
        Trace.trace(TRACE_MASKD, "Source problem system = " + sourceProblem.getFailingSystem());
        Trace.trace(TRACE_MASKD, "Verify problem system = " + verifyProblem.getFailingSystem());
        boolean related = false;
        if (sourceProblem.getFailingSystem() != null && sourceProblem.getFailingSystem().equals(verifyProblem.getFailingSystem())) {
            related = true;
        } else {
            Trace.trace(TRACE_MASKD, "PIProblemVerificationFilter.isRelatedProblem - source/verify problems from different systems");
        }
        Trace.trace(TRACE_MASKT, "<- PIProblemVerificationFilter.isRelatedProblem - returns " + related);
        return related;
    }

    protected boolean isDuplicateProblem(CommonProblem sourceProblem, CommonProblem verifyProblem) {
        Trace.trace(TRACE_MASKT, "-> PIProblemVerificationFilter.isDuplicateProblem, sourceProblem key(" + sourceProblem.getUniqueKey() + "), verifyProblem key(" + verifyProblem.getUniqueKey() + ")");
        boolean duplicate = false;
        String sourceProblemRefCode = sourceProblem.getSRC();
        String verifyProblemRefCode = verifyProblem.getSRC();
        if (sourceProblemRefCode != null && verifyProblemRefCode != null) {
            if (sourceProblemRefCode.equals(verifyProblemRefCode)) {
                duplicate = true;
            } else if (sourceProblemRefCode.length() >= 8 && verifyProblemRefCode.length() >= 8 && sourceProblemRefCode.substring(0, 8).equals(verifyProblemRefCode.substring(0, 8))) {
                duplicate = true;
            }
        } else {
            Iterator sFrusIt;
            List vFrus = verifyProblem.getParts();
            List sFrus = sourceProblem.getParts();
            LinkedList<CommonPaFru> matchingFrus = new LinkedList<CommonPaFru>();
            LinkedList<CommonPaFru> verifyProblemNonMatchingFrus = new LinkedList<CommonPaFru>();
            LinkedList<CommonPaFru> sourceProblemNonMatchingFrus = new LinkedList<CommonPaFru>();
            boolean[] sourceFruMatchArray = new boolean[sFrus.size()];
            int sourceIndex = 0;
            while (sourceIndex < sFrus.size()) {
                sourceFruMatchArray[sourceIndex++] = false;
            }
            Iterator vFrusIt = vFrus.iterator();
            while (vFrusIt.hasNext()) {
                CommonPaFru vFru = (CommonPaFru)vFrusIt.next();
                String vFruLoc = vFru.getLocation().toUpperCase();
                sFrusIt = sFrus.iterator();
                boolean foundMatch = false;
                sourceIndex = 0;
                while (sFrusIt.hasNext() && !foundMatch) {
                    CommonPaFru sFru = (CommonPaFru)sFrusIt.next();
                    String sFruLoc = sFru.getLocation().toUpperCase();
                    if (sFruLoc.equals(vFruLoc)) {
                        matchingFrus.addLast(vFru);
                        sourceFruMatchArray[sourceIndex] = true;
                        foundMatch = true;
                    }
                    ++sourceIndex;
                }
                if (!foundMatch) {
                    verifyProblemNonMatchingFrus.addLast(vFru);
                    continue;
                }
                duplicate = true;
            }
            sFrusIt = sFrus.iterator();
            sourceIndex = 0;
            while (sFrusIt.hasNext()) {
                CommonPaFru sFru = (CommonPaFru)sFrusIt.next();
                if (!sourceFruMatchArray[sourceIndex]) {
                    sourceProblemNonMatchingFrus.addLast(sFru);
                }
                ++sourceIndex;
            }
            if (verifyProblemNonMatchingFrus.size() > 0 || sourceProblemNonMatchingFrus.size() > 0) {
                LinkedList<CommonPaFru> mergedList = new LinkedList<CommonPaFru>();
                mergedList.addAll(matchingFrus);
                mergedList.addAll(mergedList.size(), verifyProblemNonMatchingFrus);
                mergedList.addAll(mergedList.size(), sourceProblemNonMatchingFrus);
                sourceProblem.removeFruList();
                CommonFruList updatedFruList = new CommonFruList();
                updatedFruList.setFrus(mergedList);
                sourceProblem.addFruList(updatedFruList);
                try {
                    ProblemManager.getProblemManager().changed(sourceProblem);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "PIProblemVerificationFilter.isDuplicateProblem - exception caught persisting the updated FRU list:" + e);
                    Trace.trace(TRACE_MASKT, e);
                    Trace.trace(TRACE_MASKT, "PIProblemVerificationFilter.isDuplicateProblem - ????...treating as a non-fatal situation - ignoring the exception and continuing");
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- PIProblemVerificationFilter.isDuplicateProblem - returns " + duplicate);
        return duplicate;
    }

    protected boolean isIgnorableProblem(CommonProblem sourceProblem, CommonProblem verifyProblem, Map userData) {
        Trace.trace(TRACE_MASKT, "-> PIProblemVerificationFilter.isIgnorableProblem, sourceProblem key(" + sourceProblem.getUniqueKey() + "), verifyProblem key(" + verifyProblem.getUniqueKey() + ")");
        boolean isIgnorable = false;
        String verifyProblemRefCode = verifyProblem.getSRC();
        if (verifyProblemRefCode != null) {
            Trace.trace(TRACE_MASKD, "verifyProblemRefCode = " + verifyProblemRefCode);
        }
        Trace.trace(TRACE_MASKD, "verifyProblem timestamp = " + verifyProblem.getProblemTimeStamp());
        Trace.trace(TRACE_MASKD, "sourceProblem timestamp = " + sourceProblem.getProblemTimeStamp());
        if (verifyProblemRefCode != null && verifyProblemRefCode.length() >= 8 && verifyProblemRefCode.substring(0, 6).equals("110015") && (verifyProblemRefCode.substring(7, 8).equals("0") || verifyProblemRefCode.substring(7, 8).equals("2") || verifyProblemRefCode.substring(7, 8).equals("4"))) {
            List selFrus = (List)userData.get("SELECTED_FRUS");
            Iterator selFrusIt = selFrus.iterator();
            while (selFrusIt.hasNext()) {
                Fru selFru = (Fru)selFrusIt.next();
                Trace.trace(TRACE_MASKD, "selected fru descr = " + (String)selFru.getProperty("DESC"));
                Trace.trace(TRACE_MASKD, "selected fru loc = " + (String)selFru.getProperty("LOCATION"));
                if (!(selFru instanceof SF2PowerSupply)) continue;
                isIgnorable = true;
                break;
            }
        }
        Trace.trace(TRACE_MASKT, "<- PIProblemVerificationFilter.isIgnorableProblem - returns " + isIgnorable);
        return isIgnorable;
    }
}

